//*************************************************************************************************************************************
//
//  Sample Program for File ( DBF & IDX TYPE )
//
//  Target Machine : CPT-711
//
//  Function:
//  int  close_DBF(int DBF_fd)                                                 : Close DBF and its associated IDX file.
//  int  open_DBF(char *filename)                                              : Open a DBF file and get the file handle of the file for further processing.
//  int  create_DBf(char *filename, usdigned member_len)                       : Create a DBF file and get the file handle of the file for further processing.
//  int  create_index(int DBF_fd, int key_number, int key_offset, int key_len) : Create an IDX file of a DBF file.
//  int  add_member(ind DBF_fd, char * member)                                 : Add a data record(member) to a DBF file.
//  long member_in_DBF(int DBF_fd)                                             : Determine how many members exist in a DBF file.
//  int  has_member(int DBF_fd, int key_number, char *key_value)               : Check if a specific member exist in an IDX file.
//  int  get_member(int DBF_fd, int key_number, char *buffer)                  : Read the member pointed by the index pointer.
//  int  delete_member(int DBF_fd, int key_number)                             : Delete a member of a DBF file.
//  int  remove(char *filename)                                                : Delete file.
//
//  SYNTECH INFORMATION CO., LTD.
//
//*************************************************************************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "..\lib\711lib.h"

void main (void)
    {
    int   i, fdbf, fidx;
    long  lfrecord;
    char  sget[10], *sdbf[] = { "111 DATA1", "222 DATA2",
                                "333 DATA3", "444 DATA4", "555 DATA5" };

    clr_scr ();
    gotoxy (2, 0);
    puts ("FILE (DBF) TEST");

    for (i=1; i<=32; i++)
        close_DBF (i);

    if (access ("DBF1"))
        fdbf = open_DBF ("DBF1");
    else
        {
        fdbf = create_DBF ((char *)"DBF1", 9);
        fidx = create_index (fdbf, 1, 0, 3);

        for (i=0; i<5; i++)
            add_member (fdbf, sdbf[i]);
        }

    lfrecord = member_in_DBF (fdbf);
    gotoxy (0, 2);
    printf ("1.DBF RECORD:[%ld]", lfrecord);

    gotoxy (2, 3);
    if (has_member (fdbf, 1, (char *)"333"))
        {
        get_member (fdbf, 1, sget);
        printf ("FOUND:[%s]", sget);
        }
    else
        puts ("DATA NOT FOUND");

    gotoxy (2, 4);
    if (delete_member (fdbf, 1))
        puts ("DELETE RECORD OK");
    else
        puts ("DELETE RECORD NG");

    lfrecord = member_in_DBF (fdbf);
    gotoxy (0, 5);
    printf ("2.DBF RECORD:[%ld]", lfrecord);

    gotoxy (2, 6);
    if (has_member (fdbf, 1, (char *)"555"))
        {
        get_member (fdbf, 1, sget);
        printf ("FOUND:[%s]", sget);
        }
    else
        puts ("DATA NOT FOUND");

    close_DBF (fdbf);

    gotoxy (2, 7);
    if (remove("DBF1"))
        puts ("DBF DELETE OK");
    else
        puts ("DBF DELETE NG");

    while (getchar() != KEY_ESC);
    }
//-------------------------------------------------------------------------//

